------------------------------------------------
-- added to make below compile
------------------------------------------------
package test5 is
------------------------------------------------
TYPE current IS RANGE 0 to 1000000000

UNITS
  na;            -- nano amps
  ua = 1000 na;  -- micro amps
  ma = 1000 ua;  -- milli amps
  a  = 1000 ma;  -- amps
END UNITS;          
------------------------------------------------
end test5;
------------------------------------------------



PACKAGE example IS
  TYPE current IS RANGE 0 TO 1000000000
    UNITS
      na;            -- nano amps
      ua = 1000 na;  -- micro amps
      ma = 1000 ua;  -- milli amps
      a  = 1000 ma;  -- amps
    END UNITS;

  TYPE load_factor IS (small, med, big );
END example;

USE WORK.example.ALL;
ENTITY delay_calc IS
  PORT ( out_current : OUT current;
         load : IN load_factor;
         delay : OUT time);
END delay_calc;

ARCHITECTURE delay_calc OF delay_calc IS
BEGIN
  delay <= 10 ns WHEN (load = small) ELSE
           20 ns WHEN (load = med) ELSE
           30 ns WHEN (load = big) ELSE
           10 ns;

  out_current <= 100 ua WHEN (load = small)ELSE
                 1 ma   WHEN (load = med) ELSE
                 10 ma  WHEN (load = big) ELSE
                 100 ua;
END delay_calc;
